/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.BindingFinder;
import org.python.indexer.ast.NBlock;
import org.python.indexer.ast.NBody;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLambda
extends NFunctionDef {
    static final long serialVersionUID = 7737836525970653522L;
    private NName fname;

    public NLambda(List<NNode> list, NNode nNode, List<NNode> list2, NName nName, NName nName2) {
        this(list, nNode, list2, nName, nName2, 0, 1);
    }

    public NLambda(List<NNode> list, NNode nNode, List<NNode> list2, NName nName, NName nName2, int n, int n2) {
        super(null, list, null, list2, nName, nName2, n, n2);
        this.body = nNode instanceof NBlock ? new NBody((NBlock)nNode) : nNode;
        this.addChildren(this.body);
    }

    @Override
    public boolean isLambda() {
        return true;
    }

    @Override
    protected String getBindingName(Scope scope) {
        if (this.fname != null) {
            return this.fname.id;
        }
        String string = scope.newLambdaName();
        this.fname = new NName(string, this.start(), this.start() + "lambda".length());
        this.fname.setParent(this);
        return string;
    }

    @Override
    protected void bindFunctionName(Scope scope) throws Exception {
        NameBinder.make(NBinding.Kind.FUNCTION).bindName(scope, this.fname, this.getType());
    }

    @Override
    protected void bindMethodAttrs(Scope scope) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NType resolve(Scope scope) throws Exception {
        Object object;
        if (!this.getType().isFuncType()) {
            Indexer.idx.reportFailedAssertion("Bad type on " + this + ": type=" + this.getType() + " in file " + this.getFile() + " at " + this.start());
        }
        NTupleType nTupleType = new NTupleType();
        NameBinder nameBinder = NameBinder.make(NBinding.Kind.PARAMETER);
        this.resolveList(this.defaults, scope);
        Scope scope2 = this.getTable();
        int n = 0;
        for (NNode nNode : this.args) {
            NType nType = NFunctionDef.getArgType(this.args, this.defaults, n++);
            nameBinder.bind(scope2, nNode, nType);
            nTupleType.add(nType);
        }
        if (this.varargs != null) {
            object = new NUnknownType();
            nameBinder.bind(scope2, this.varargs, (NType)object);
            nTupleType.add((NType)object);
        }
        if (this.kwargs != null) {
            object = new NUnknownType();
            nameBinder.bind(scope2, this.kwargs, (NType)object);
            nTupleType.add((NType)object);
        }
        try {
            scope2.setNameBindingPhase(true);
            this.body.visit(new BindingFinder(scope2));
        }
        finally {
            scope2.setNameBindingPhase(false);
        }
        object = NLambda.resolveExpr(this.body, scope2);
        if (this.getType().isFuncType()) {
            this.getType().asFuncType().setReturnType((NType)object);
        }
        return this.getType();
    }

    @Override
    public String toString() {
        return "<Lambda:" + this.start() + ":" + this.args + ":" + this.body + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNodeList(this.args, nNodeVisitor);
            this.visitNodeList(this.defaults, nNodeVisitor);
            this.visitNode(this.varargs, nNodeVisitor);
            this.visitNode(this.kwargs, nNodeVisitor);
            this.visitNode(this.body, nNodeVisitor);
        }
    }
}

